//MegaPOV 1.0
// 468x351 for 100% (72 dpi)
//anti-aliasing 2 (adaptive), threshold .5, recursion 3
//1952x1464 for 300dpi

//7650x3300 for 300dpi and 3 pages wide (ratio: 51:22)
//4800 by 2070 for zazzle poster

#include "colors.inc"
#include "stones.inc"
#include "woods.inc"
#include "torch.inc"

#declare poster = 0;
#declare widescreen = 0;
#declare fadelight = 1;
#declare fadedistance = 2;

#declare in_alcove = 0;
#declare bird_high = 1;
#declare bird_alcove = 2;
#declare bird_mainhall = 3;
#declare in_temple = 4;
#declare alcove_right = 5;
#declare corner_closeup = 6;
#declare right_corner = 7;
#declare other_corner = 8;
#declare from_hallway = 9;

#declare view =in_alcove;
//#declare view=bird_alcove;
//#declare view=bird_high;
//#declare view = corner_closeup;
//#declare view = other_corner;
//#declare view = in_temple;
//#declare view = from_hallway;

#declare show_ceiling = 1;
#declare full_torch = 1;

#declare eye_height = 5.4;
#declare ceiling_height = 6.5;
#declare temple_height = ceiling_height * sqrt(2);
#declare wall_thickness = .1;
#declare door_thickness = .25;
#declare door_width = 2.5;
#declare door_height = ceiling_height-.2;

//defaults, and for view in_alcove
#declare my_location = <.1, eye_height, .1>;
#declare my_focus = <-4, eye_height-.6, 2.9>;
#declare torch_location = my_location + <-.4, .3, 1.2>;

#if (view = in_alcove)
	#if (widescreen = 1)
		#declare my_location = my_location - <0, 1, -1>;
		#declare my_focus = my_focus - <0, 1, 1>;
	#end
#end

#include "temple.inc"
#include "sidings.inc"

#if (view = alcove_right)
	#declare my_location = <-4.1, eye_height, 1.1>;
	#declare my_focus = <3, my_focus.y, 0>;
#end

//birds-eye view
#if (view = bird_high)
	#declare my_location = <-1.5, ceiling_height*8, 4>;
	#declare my_focus = my_location - <0, my_location.y, 0>;
	#declare show_ceiling = 0;
	global_settings {
		ambient_light 4
	}
#end

#if (view = bird_alcove)
	#declare my_location = <-1.5, ceiling_height*2.5, 2.5>;
	#declare my_focus = my_location - <0, my_location.y, 0>;
	#declare show_ceiling = 0;
	global_settings {
		ambient_light 4
	}
#end

#if (view = bird_mainhall)
	#declare my_location = <-1.5, ceiling_height*2, -4>;
	#declare my_focus = my_location - <0, my_location.y, 0>;
	#declare show_ceiling = 0;
	#declare full_torch = 0;
	#declare torch_location = my_location;
	global_settings {
		ambient_light 4
	}
#end

#ifdef (poster)
	global_settings {
		ambient_light 2
	}
#end

#if (view = in_alcove)
	global_settings {
		ambient_light 3
	}
#end

//from the outerhallway
#if (view = from_hallway)
	#declare my_location = <-1.5, my_location.y, -6.5>;
	#declare my_focus = <-2.5, my_focus.y, 4>;
	#declare torch_location = <-1, torch_location.y, -6>;
#end

//temple view
#if (view = in_temple)
	#declare temple_z = (23.5+6.5)/2;
	#declare temple_x = 11;
	#declare my_location =<temple_x, my_location.y, temple_z>;
	#declare my_focus = <-20, my_focus.y, temple_z-1>;
	#declare torch_location = <temple_x, torch_location.y, temple_z>;
#end

#if (view = corner_closeup)
	#declare my_location = <-2, eye_height, 3>;
	#declare my_focus = <-3, ceiling_height, 4>;
#end

#if (view = other_corner)
	#declare my_location = my_location + <-2, -.5, .05>;
	#declare my_focus = <-7, ceiling_height, .5>;
#end

#if (view = right_corner)
	#declare my_location = <-4, 5.4, 2>;
	#declare my_focus = <-7, 5.4, 3>;
#end


camera {
	location my_location
	look_at my_focus

	#if (widescreen = 1)
		up y
		right 55/22*x
	#end
}

#if (full_torch = 1)
	#declare light_divider = 4;
	light_source {
		torch_location + <-1/12, 1.5/12, -1/12>
		color <.9, .6, .2>/light_divider

#if (fadelight = 1)
		fade_distance fadedistance
		fade_power 2
#end
	}
	light_source {
		torch_location + <1/12, -2/12, -.5/12>
		color <.8, .75, .2>/light_divider
#if (fadelight = 1)
		fade_distance fadedistance
		fade_power 2
#end
	}
	light_source {
		torch_location + <-2/12, -3/12, .5/12>
		color <.6, .6, .4>/light_divider
#if (fadelight = 1)
		fade_distance fadedistance
		fade_power 2
#end
	}
#else
	#declare light_divider = 1;
#end

light_source {
	torch_location
	color <.9, .7, .3>/light_divider
#if (fadelight = 1)
		fade_distance fadedistance
		fade_power 2
#end
}


#include "things.inc"

//hallway
union {
//floor
	plane {
		y, 0
		texture { floor_texture }
	}
	
	
	//rear hall wall, 45 feet wide
	box {
		<-30, 0, -7>, <15, ceiling_height, -7-wall_thickness>
	}
	object { stonewall(45-siding_size-wall_thickness, ceiling_height*.5)
		translate <-30+(siding_size+wall_thickness), ceiling_height*.4, -7+siding_size/2>
	}
	
	//forward hall wall
	box {
		<-29, 0, -2.5>, <-3-siding_size, ceiling_height, -2.5+wall_thickness>
	}
	object { stonewall(26, ceiling_height*.5)
		translate <-29+(siding_size+wall_thickness), ceiling_height*.4, -2.5>
	}

	box {
		<0+siding_size, 0, -2.5>, <15, ceiling_height, -2.5+wall_thickness>
	}
	object { stonewall(15, ceiling_height*.5)
		translate <0, ceiling_height*.4, -2.5>
	}
	
	//entrance hall
	box {
		<-3-wall_thickness, 0, -2.5+siding_size>, <-3, ceiling_height, 0-siding_size>
	}
	object { stonewall(2.5-siding_size*4, ceiling_height*.5)
		rotate <0, 90, 0>
		translate <-3+siding_size/2, ceiling_height*.4, 2.5-siding_size*2-2.5>
	}
	box {
		<0, 0, -2.5+siding_size>, <wall_thickness, ceiling_height, 0-siding_size>
	}
	object { stonewall(2.5-siding_size*4, ceiling_height*.5)
		rotate <0, 90, 0>
		translate <0-siding_size/2, ceiling_height*.4, 2.5-siding_size*2-2.5>
	}

	//corner siding on corner of left alcove and entrance hall
	object { outiesiding
		scale <1, ceiling_height, 1>
		translate <-3-siding_size, 0, 0-siding_size>
	}
	//the corner connector between left alcove and entrance hall
	object { cornersiding
		scale <1, -1, -1>
		translate <-3-siding_size, ceiling_height, 0>
	}
	//horizontal ceiling siding on left entrance wall (near left alcove)
	object { siding
		rotate <0, -90, 0>
		scale <1, -1, 1>
		scale <1, 1, 2.5-siding_size*2>
		translate <-3, ceiling_height, -2.5+siding_size>
	}
	//corner siding on corner of entrance hall and main hall, left alcove side
	object { outiesiding
		scale <1, ceiling_height, 1>
		translate <-3-siding_size, 0, -2.5+siding_size>
	}

	//corner siding on corner of entrance hall and right alcove
	object { outiesiding
		scale <1, ceiling_height, 1>
		translate <siding_size, 0, 0-siding_size>
	}
	//the corner connector between right alcove and entrance hall
	object { cornersiding
		scale <-1, -1, -1>
		translate <siding_size, ceiling_height, 0>
	}
	//horizontal ceiling siding on right entrance wall (near right alcove)
	object { siding
		rotate <0, -90, 0>
		scale <-1, -1, 1>
		scale <1, 1, 2.5-siding_size*2>
		translate <0, ceiling_height, -2.5+siding_size>
	}
	
	//corner siding on corner of entrance hall and main hall, right alcove side
	object { outiesiding
		scale <1, ceiling_height, 1>
		translate <siding_size, 0, -2.5+siding_size>
	}

	//exit hall
	box {
		<-3-wall_thickness, 0, 4+siding_size>, <-3, ceiling_height, 6.5-siding_size>
	}
	object { stonewall(2.5-siding_size*4, ceiling_height*.5)
		rotate <0, 90, 0>
		translate <-3+siding_size/2, ceiling_height*.4, 2.5-siding_size*2 + 4>
	}
	
	box {
		<0, 0, 4+siding_size>, <wall_thickness, ceiling_height, 6.5-siding_size>
	}
	object { stonewall(2.5-siding_size*4, ceiling_height*.5)
		rotate <0, 90, 0>
		translate <0-siding_size/2, ceiling_height*.4, 2.5-siding_size*2+4>
	}

	//horizontal ceiling siding on left wall (near left alcove)
	object { siding
		rotate <0, -90, 0>
		scale <1, -1, 1>
		scale <1, 1, 2.5-siding_size*2>
		translate <-3, ceiling_height, 4+siding_size>
	}
	
	//the corner connector on left side between alcove and exit hall
	object { cornersiding
		scale <1, -1, 1>
		translate <-3-siding_size, ceiling_height, 4>
	}
	//the corner connector on left side between exit hall and temple
	object { cornersiding
		scale <1, -1, -1>
		translate <-3-siding_size, ceiling_height, 6.5>
	}
	
	//corner siding on near corner
	//the translation might slightly wrong as I modified the
	//siding_size mods thinking this was the corner connector
	object { outiesiding
		scale <1, ceiling_height, 1>
		translate <-3-siding_size, 0, 4+siding_size>
	}
	//horizontal ceiling siding on right exit wall (near right alcove)
	object { siding
		rotate <0, -90, 0>
		scale <-1, -1, 1>
		scale <1, 1, 2.5-siding_size*2>
		translate <0, ceiling_height, 4+siding_size>
	}
	
//the corner connector between right alcove and exit hall
	object { cornersiding
		scale <-1, -1, 1>
		translate <siding_size, ceiling_height, 4>
	}
	//the corner connector between right alcove and exit hall
	object { cornersiding
		scale <-1, -1, -1>
		translate <siding_size, ceiling_height, 6.5>
	}

	//corner siding on far corner
	object { outiesiding
		scale <1, temple_height, 1>
		translate <-3-siding_size, 0, 6.5-siding_size>
	}

	//corner siding on near near corner
	object { outiesiding
		scale <1, ceiling_height, 1>
		translate <siding_size, 0, 4+siding_size>
	}
	//corner siding on near far corner
	object { outiesiding
		scale <1, temple_height, 1>
		translate <siding_size, 0, 6.5-siding_size>
	}


	//left alcove
	//side walls
	box {
		<-7-wall_thickness, 0, 0>, <-3-siding_size, ceiling_height, -wall_thickness>
	}
	object { stonewall(4-siding_size-wall_thickness, ceiling_height*.5)
		translate <-3-4+(siding_size+wall_thickness), ceiling_height*.4, siding_size/2>
	}

	box {
		<-7-wall_thickness, 0, 4>, <-3-siding_size, ceiling_height, 4+wall_thickness>
	}
	object { stonewall(4-siding_size-wall_thickness, ceiling_height*.5)
		translate <-3-4+(siding_size+wall_thickness), ceiling_height*.4, 4>
	}
	
	//wall with picture
	difference {
		box {
			<-7-wall_thickness*10, 0, 0>, <-7, ceiling_height, 4>
		}
		superellipsoid {
			<.1, .1>
			translate 1
			scale .51
			
			scale < carving_Size.z*6, carving_Size.y*carving_Ratio, carving_Size.x>
			translate <-carving_Size.z*3, 0, 0>
			translate <-7, 0, 0>
			translate carving_Location
			translate <-.1, 0, -carving_Location.z*.85>
		}
	}
	
	//far vertical siding
	object { siding
		rotate <0, 0, 90>
		scale <-1, 1, 1>
		scale <1, ceiling_height, 1>
		translate <-7, 0, 4>
	}
	//near vertical siding
	object { siding
		rotate <0, 0, 90>
		scale <-1, 1, -1>
		scale <1, ceiling_height, 1>
		translate <-7, 0, 0>
}
	//horizontal ceiling siding on far wall
	object { siding
		rotate <0, -90, 0>
		scale <1, -1, 1>
		scale <1, 1, 4>
		translate <-7, ceiling_height, 0>
	}
	//horizontal siding on ceiling of left wall
	object { siding
		scale <1, -1, -1>
		scale <4, 1, 1>
		translate <-7, ceiling_height, 0>
	}
	//horizontal siding on ceiling of right wall
	object { siding
		scale <1, -1, 1>
		scale <4-siding_size, 1, 1>
		translate <-7, ceiling_height, 4>
	}

	object { kneeler
		translate <-7, 0, 0>
	}
	object { jumbledBones
		translate <-4.8, .8, 3.2>
		//translate <-5, -2.7, 1>
	}
	
	object { woodcarving
		translate <-7, 0, 0>
	}
	object { torchSet
		//rotate <-20, 0, 2>
		translate <-2 - torch_X, 0, 4>
	}
	object { torchSet
		//rotate <20, 0, -3>
		scale <-1, 1, -1>
		translate <-2 - torch_X, 0, 0>
	} 

	//right alcove
	box {
		<0+siding_size, 0, 0>, <4+wall_thickness, ceiling_height, -wall_thickness>
	}
	object { stonewall(4-siding_size-wall_thickness, ceiling_height*.5)
		translate <(siding_size+wall_thickness), ceiling_height*.4, siding_size/2>
	}

	box {
		<0+siding_size, 0, 4>, <4+wall_thickness, ceiling_height, 4+wall_thickness>
	}
	object { stonewall(4-siding_size-wall_thickness, ceiling_height*.5)
		translate <(siding_size+wall_thickness), ceiling_height*.4, 4>
	}
	
	//wall with picture
	box {
		<4, 0, 0>, <4+wall_thickness, ceiling_height, 4>
	}
	
	//far vertical siding (near main hallway)
	object { siding
		rotate <0, 0, 90>
		//scale <-1, 1, 1>
		scale <1, ceiling_height, 1>
		translate <4, 0, 4>
	}
	//near vertical siding (near temple)
	object { siding
		rotate <0, 0, 90>
		scale <1, 1, -1>
		scale <1, ceiling_height, 1>
		translate <4, 0, 0>
}
	//horizontal ceiling siding on far wall (above picture)
	object { siding
		rotate <0, -90, 0>
		scale <-1, -1, 1>
		scale <1, 1, 4>
		translate <4, ceiling_height, 0>
	}
	//horizontal siding on ceiling of left wall (near main hall)
	object { siding
		scale <1, -1, -1>
		scale <4-siding_size, 1, 1>
		translate <0+siding_size, ceiling_height, 0>
	}
	//horizontal siding on ceiling of right wall (near temple)
	object { siding
		scale <1, -1, 1>
		scale <4-siding_size, 1, 1>
		translate <0+siding_size, ceiling_height, 4>
	}

	object { kneeler
		scale <-1, 1, 1>
		translate <4, 0, 0>
	}
	object { woodcarving
		scale <-1, 1, 1>
		translate <4, 0, 0>
	}
	object { torchSet
		//rotate <-20, 0, 2>
		scale <1, 1, 1>
		translate <torch_X, 0, 4>
	}
	object { torchSet
		//rotate <20, 0, -3>
		scale <-1, 1, -1>
		translate <torch_X, 0, 0>
	} 


	//one ceiling to cover it all
	#if (show_ceiling = 1)
		box {
			<-30, ceiling_height, -7>, <15, ceiling_height+wall_thickness, 6.5>
		}
	#end
	
	//temple
	//near wall
	box {
		<0+siding_size, 0, 6.5>, <14, temple_height, 6.5-wall_thickness>
	}
	object { stonewall(14, temple_height*.5)
		translate <0+siding_size/2, temple_height*.4, 6.5+wall_thickness/2>
	}
	box {
		<-25, 0, 6.5>, <-3-siding_size, temple_height, 6.5-wall_thickness>
	}
	object { stonewall(22, temple_height*.5)
		translate <-25+siding_size/2, temple_height*.4, 6.5+wall_thickness/2>
	}
	
	object { doorWithPlate
		rotate <0, 26, 0>
		translate <-door_thickness, 0, 0>
		translate <0, .1, 5>
	}
	
	//far wall
	box {
		<-25, 0, 23.5>, <14, temple_height, 23.5+wall_thickness>
	}
 	object { stonewall(39, temple_height*.5)
		translate <-25+siding_size/2, temple_height*.4, 23.5>
	}

	
	//side walls
	box {
		<-25-wall_thickness, 0, 6.5-wall_thickness>, <-25, temple_height, 23.5+wall_thickness>
	}
	object { stonewall(17, temple_height*.5)
		rotate <0, 90, 0>
		translate <-25, temple_height*.4, 6.5+17>
	}
	box {
		<14, 0, 6.5-wall_thickness>, <14+wall_thickness, temple_height, 23.5+wall_thickness>
	}
	object { stonewall(17, temple_height*.5)
		rotate <0, 90, 0>
		translate <14, temple_height*.4, 6.5+17>
	}
	
	//the temple ceiling
	#if (show_ceiling = 1)
		box {
			<-25-wall_thickness, temple_height, 6.5-wall_thickness>,
			<14+wall_thickness, temple_height+wall_thickness, 23.5+wall_thickness>
		}
	#end
	
	//the altar area
	#declare side_space = 2.25;
	#declare dais_radius = (23.5-6.5)/2-side_space;
	#declare dais_center = <-25, 0, 6.5+dais_radius+side_space>;
	#declare dais_height = pi/10;
	cylinder {
		dais_center, dais_center + dais_height*y, dais_radius
		texture { T_Stone3}
	}
	cylinder {
		dais_center + dais_height*y, dais_center + dais_height*y*2, dais_radius - .75
		texture { T_Stone3}
	}
	cylinder {
		dais_center + dais_height*y*2, dais_center + dais_height*y*3, dais_radius - .75*2
		texture { T_Stone3}
	}
	object { column
		translate <dais_center.x+dais_radius, 0, dais_center.z+dais_radius*2/3>
		texture { T_Stone3}
	}
	object { column
		translate <dais_center.x+dais_radius, 0, dais_center.z-dais_radius*2/3>
		texture { T_Stone3}
	}

	//the altar
	box {
		<-.5, 0, 0>, <.5, 1, 1>
		scale <5.5, 4, 3>
		rotate <0, 90, 0>
		translate dais_center
		texture {T_Grnt15}
	}
	
	//the side door
	//for some reason neither the handle nor the plate shows up
	object { doorWithHandle
		scale .85
		rotate <0, 90, 0>
		translate dais_center
		translate <0, 0, dais_radius>
	}
	
	//the kneelers
	#declare pewEnd = -16;
	#declare pewCount = 7;
	#declare pewStart = 0;
	#declare currentPew = 0;
	#while (currentPew < pewCount)
		object { pew
			translate <pewStart+currentPew*pewEnd/pewCount, 0, 9>
		}
		#declare currentPew = currentPew + 1;
	#end
	
	texture {	wall_texture }
}

background {
	color White
}

#if (widescreen = 1)
	#include "widescreen.inc"
#end